﻿/*	VERSION:  1.3
1.3		Added .width and .height data to the returned promise
1.2		Change:	Failure returns undefined instead of an error string,  because I typically test for failure by looking for undefined or falsey values.
1.1		include loadImage.as locally

USAGE
	#include "functions/VOW.as"
	#include "functions/VOW/loadImageFile.as"
	
	loadImageFile( file, [target], [newName], [newDepth], [isVisible] )
	.then( doStuff );
	

NOTE:
	The input path parameter be a file path or internal linkage.
	SWF files, Image files, Image linkage, and BitmapData can be loaded.
	
	
DESCRIPTION:
	Uses loadImage() to load a file into a movieClip
	and returns a promise.
	This can load:
		external SWF files
		external image files
		linkage MovieClips
		linkage images
		raw BitmapData
	
	The promise will output a reference to the new movieClip
	ONLY if parent and instanceName parameters are provided.
	
	
*/
#include "loadImageFile/loadImage.as"

var loadImageFile = function( fileName_str, target, newName, newDepth, isVisible ){
	var vow = VOW.make();
	
	var loader = loadImage( fileName_str, target, newName, newDepth, isVisible );
	var success = function( mc ){
		// var ref = target[newName];
		vow.promise.width = mc._width;
		vow.promise.height = mc._height;
		vow.keep( mc );
	}
	loader.onLoadInit = success;
	if(!loader)		// if:  no loader was needed
		success();
	loader.onLoadError = function(){
		var msg = "Failed to load image:  "+fileName_str;
		trace( msg );
		vow.doBreak( undefined );
	}
	
	vow.promise.width = loader.width;
	vow.promise.height = loader.height;
	return vow.promise;
}// loadImageFile()